﻿from microcontroleurs import arduino
import matplotlib.pyplot as plt
import numpy as np

#creation de la commuication avec la carte arduino
#le numero du port COM est à modifier
macarte = arduino("COM3")

#crée deux listes vides pour mettre les mesures
invP = []
volume = []

#demande à l'utilisateur le nb de points de mesure
nb_points=int(input("Entrez le nombre de points de mesure :"))

#remplit les listes avec les valeurs
for i in range(nb_points):
    #ajoute V dans la liste où V est entré par l'utilisateur
    volume.append(int(input("Entrez le volume V en mL :")))
    #ajoute 1/P mesuree par le capteur à la liste
    tension=macarte.entree_analogique(0) * 5 / 1023
    invP.append(1/(tension / 0.0006429 - 311))

#arrêt de la communication avec la carte arduino
macarte.fermer()
print(invP)
print(volume)
#equation de la caractéristique
modele=np.polyfit(invP,volume,1)
print("V = ",round(modele[0],1)," /p + ",round(modele[1],1))

# trace les points expérimentaux
plt.scatter(invP,volume, marker='o', color='blue' , label = "Points expérimentaux")   # points bleus
# trace la droite d'ajustement
invP2= np.asarray(invP)   #transforme la liste en tableau ... pour faire des calculs avec dans la ligne suivante
plt.plot(invP2, modele[0]*invP2 + modele[1],'r--', label = "Modélisation")   #tirets rouges
plt.axis([0,0.0015,10,70])
plt.title("Volume = f(1/p)")
plt.xlabel("1/p (hPa-1)")
plt.ylabel("Volume (mL)")
plt.legend(loc ="upper left")
plt.show()



